/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.items.pearls;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import tech.alexnijjar.endermanoverhaul.client.EndermanOverhaulClient;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantComponents;
import tech.alexnijjar.endermanoverhaul.common.entities.projectiles.ThrownSoulPearl;
import tech.alexnijjar.endermanoverhaul.common.registry.ModDataComponents;

public class SoulPearlItem
extends EnderpearlItem {
    public SoulPearlItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        if (player.isShiftKeyDown()) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
        }
        ItemStack itemStack = player.getItemInHand(usedHand);
        int id = this.getBoundEntityId(itemStack);
        Entity entity = level.getEntity(id);
        if (entity == null) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDER_PEARL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        player.getCooldowns().addCooldown((Item)this, 20);
        if (!level.isClientSide()) {
            ThrownSoulPearl pearl = new ThrownSoulPearl(level, (LivingEntity)player, entity);
            pearl.setItem(itemStack);
            pearl.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)pearl);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity interactionTarget, @NotNull InteractionHand usedHand) {
        if (!player.level().isClientSide() && player.isShiftKeyDown() && !interactionTarget.getType().is(Tags.EntityTypes.TELEPORTING_NOT_SUPPORTED)) {
            if (interactionTarget.getId() == this.getBoundEntityId(stack)) {
                return InteractionResult.PASS;
            }
            ItemStack copy = stack.copy();
            copy.setCount(1);
            this.setBoundEntityId(copy, interactionTarget.getId());
            Component displayName = interactionTarget.getDisplayName();
            if (displayName == null) {
                return InteractionResult.FAIL;
            }
            player.displayClientMessage((Component)Component.translatable((String)"tooltip.endermanoverhaul.bound_to", (Object[])new Object[]{displayName}), true);
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EVOKER_CAST_SPELL, SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (stack.getCount() == 1) {
                player.setItemInHand(usedHand, copy);
            } else {
                stack.shrink(1);
                if (!player.getInventory().add(copy)) {
                    player.drop(copy, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.interactLivingEntity(stack, player, interactionTarget, usedHand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add(ConstantComponents.SOUL_PEARL_TOOLTIP_1);
        tooltipComponents.add(ConstantComponents.SOUL_PEARL_TOOLTIP_2);
        if (this.isBound(stack)) {
            Level level = EndermanOverhaulClient.getLevel();
            if (level == null) {
                return;
            }
            int id = this.getBoundEntityId(stack);
            Entity entity = level.getEntity(id);
            if (entity == null) {
                return;
            }
            Component displayName = entity.getDisplayName();
            if (displayName == null) {
                return;
            }
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.endermanoverhaul.bound_to", (Object[])new Object[]{displayName.getString()}).withStyle(ChatFormatting.GREEN));
        } else {
            tooltipComponents.add(ConstantComponents.NOT_BOUND);
        }
    }

    public void inventoryTick(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        int id;
        Entity boundEntity;
        if (level.isClientSide()) {
            return;
        }
        if ((entity.tickCount + entity.getId()) % 100 != 0) {
            return;
        }
        if (this.isBound(stack) && (boundEntity = level.getEntity(id = this.getBoundEntityId(stack))) == null) {
            this.setBoundEntityId(stack, -1);
        }
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return this.isBound(stack) || super.isFoil(stack);
    }

    public boolean isBound(ItemStack stack) {
        return this.getBoundEntityId(stack) >= 0;
    }

    public int getBoundEntityId(ItemStack stack) {
        return (Integer)stack.getOrDefault((DataComponentType)ModDataComponents.BOUND_ENTITY.get(), (Object)-1);
    }

    public void setBoundEntityId(ItemStack stack, int id) {
        stack.set((DataComponentType)ModDataComponents.BOUND_ENTITY.get(), (Object)id);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

